using System;

public abstract class Shape
{
  public abstract void Draw();
  public virtual String Opis()
  {
    return "Opis kształtu";
  }
}

public class Rectangle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("Jestem prostokątem.");
  }
  public override String Opis()
  {
    return "Opis prostokąta";
  }
}

public class Triangle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("Jestem trójkątem.");
  }
}

public class Program
{
  public static void DrawShape(Shape shape)
  {
    shape.Draw();
  }
  public static void Main()
  {
    Triangle triangle = new Triangle();
    Rectangle rectangle = new Rectangle();

    Console.WriteLine("Wywołania metod draw:");
    DrawShape(triangle);
    DrawShape(rectangle);
    Console.WriteLine("");

    Console.WriteLine("Wywołania metod Opis:");
    Console.WriteLine(triangle.Opis());
    Console.WriteLine(rectangle.Opis());
  }
}
